<?php

namespace App\Services\Asset;

use App\Events\BulkUpdates;
use App\Models\Asset;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;

class AssetLockService
{
    public function __construct() {}

    /**
     * Retrieves the unlock code for a specified asset.
     *
     * @param array $data An array containing asset details, including 'asset_id' and 'lock_code'.
     * @return array|bool Returns an array with the 'status' and 'unlock_code' if successful, or false if asset not found.
     */

    public function getUnlockCode($data)
    {
        $asset = Asset::find($data['asset_id']);
        if ($asset === null) {
            return false;
        }

        $data['status'] = 'success';
        $data['unlock_code'] = $asset->unlock_code ?? '';

        $this->creteLockCodePulledHistory($asset, $data['unlock_code']);

        return $data;
    }

    /**
     * Created the lock code pull history for the asset
     * @param mixed $asset
     * 
     * @return bool
     */
    public function creteLockCodePulledHistory($asset, $lockCode)
    {

        $historyDescription = "history.lockCodePulled";

        $assetHistory = [
            'asset_id' => $asset->id,
            'user_id' => Auth::user()->id,
            'action'      => 'lockCode_pulled',
            'lock_code'   => $lockCode ?? '',
            'description' => __($historyDescription, [
                'asset_name' => $asset->serial_no,
                'asset_id' => $asset->id,
            ]),
            'created_at' => Carbon::now()->format('Y-m-d H:i:s'),
            'updated_at' => Carbon::now()->format('Y-m-d H:i:s'),
        ];

        event(new BulkUpdates($assetHistory));
    }
}
