<?php

namespace App\Services\Asn\Shi;

use App\Models\AsnUnwantedPart;
use App\Services\Asn\AbstractAsnMappingService;
use Exception;

/**
 * Service class for SHI assets unwanted parts
 */
class ShiUnwantedPartsService  extends AbstractAsnMappingService
{
    /**
     * Gets all unwanted parts added.
     * @return collection
     */
    public function getUnwantedPartsData()
    {
        return $asnUnwantedParts = AsnUnwantedPart::where('provider', 'shi')->get();
    }

    /**
     * Search through unwanted parts mappings
     * @return collection
     */
    public function getUnwantedPartsSearch()
    {
        $searchText = request('searchText');
        $shiMappings = AsnUnwantedPart::where('provider', 'shi');

        if ($searchText) {
            $shiMappings = $shiMappings->where('part_no',  'like', '%' . $searchText . '%');
        }

        return $shiMappings->get();
    }

    /**
     * Handles the unwanted parts bulk upload process
     * @return string
     */
    public function bulkUpload()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        
        $extension = strtolower(request()->file('unwanted-parts-bulk-upload')->getClientOriginalExtension());
        $path = request()->file('unwanted-parts-bulk-upload')->storeAs('public/shi_mapping_bulk_upload', 'shi-unwanted-parts-' . date('YmdHis') . '.' . $extension);
        $path = storage_path('app/' . $path);
        $headerMap = Config('bulk-upload.asnUnwantedParts');
        $checkHeader =  $this->checkHeader($path, $headerMap);
        if ($checkHeader) {
            $errors = 'Upload file do not match the template';

            return compact('errors');
        }
        $errors =  $this->importUnwantedPartsMappingData($path, 'shi');
        if ($errors) {
            $message = 'Mapping completed with errors';

            return compact('message', 'errors');
        }
        $message = 'Bulk mapping successful.';
        return compact('message');
    }
}
