<?php

namespace App\Services\Asn\Shi;

use App\Repositories\Asn\ShiAssetsRepository;
use App\Models\AsnAccessoriesMapping;
use App\Services\Asn\AbstractAsnMappingService;
use Exception;

class ShiAccessoriesMappingService extends AbstractAsnMappingService
{
    protected  $repository;
    /**
     * AccessoriesMappingService Constructor
     *
     * @param ShiAssetsRepository $repository
     */
    public function __construct(ShiAssetsRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Get Accessories mapping data
     *
     * @return Eloquent
     */
    public function getAccessoriesMappingData()
    {
        return $asnMappingData = $this->repository->getAccessoriesMappingData()->get();
    }

    /**
     * Filter data
     *
     * @return Eloquent
     */
    public function getAccessoriesMappingSearch()
    {
        $searchText = request('searchText');
        $asnMappingData = $this->repository->getAccessoriesMappingData();

        if ($searchText) {
            $asnMappingData = $asnMappingData->where('part_no', 'like', '%' . $searchText . '%');
        }

        return $asnMappingData = $asnMappingData->get();
    }

    /**
     * Bulk upload
     *
     */
    public function bulkUpload()
    {
        $extension = strtolower(request()->file('shi-accessories-mapping-upload')->getClientOriginalExtension());
        $path = request()->file('shi-accessories-mapping-upload')->storeAs('public/shi_mapping_bulk_upload', 'shi-accessories-mapping-' . date('YmdHis') . '.' . $extension);
        $path = storage_path('app/' . $path);
        $message = 'Bulk mapping successful.';
        $headerMap = Config('bulk-upload.asnAccessoriesMappingData');
        $checkHeader =  $this->checkHeader($path, $headerMap);
        if ($checkHeader) {
            $errors = 'Upload file do not match the template';

            return compact('errors');
        }

        $errors =  $this->importAccessoryMappingData($path, 'shi');

        if ($errors) {
            $message = 'Mapping completed with errors';

            return compact('message', 'error');
        }

        $message = 'Bulk mapping successful.';

        return compact('message');
    }
}
