<?php

namespace App\Services\Asn\Presidio;

use App\Models\AsnUnwantedPart;
use App\Services\Asn\AbstractAsnMappingService;

class PresidioUnwantedPartsService extends AbstractAsnMappingService
{

    /**
     * Gets all unwanted parts added.
     * @return mixed
     */
    public function getUnwantedPartsData()
    {
        return AsnUnwantedPart::where('provider', 'presidio');
    }


    /**
     * Search for AsnUnwantedPart data where given search text matches with 'part_no' field
     *
     * @return mixed
     */
    public function getUnwantedPartsSearch()
    {
        $searchText         = request('searchText');
        $presidioMappings   = $this->getUnwantedPartsData()->get();

        if ($searchText) {

            $presidioMappings   = $this->getUnwantedPartsData()->where('part_no',  'like', '%' . $searchText . '%')->get();
        }

        return $presidioMappings;
    }

    /**
     * Saves AsnUnwantedPart data from uploaded csv file
     *
     * @param $request
     *
     * @return array
     */
    public function bulkUpload($request)
    {
        $file       = $request->file('file');
        $extension  = strtolower($file->getClientOriginalExtension());

        $path           = $file->storeAs('public/presidio_mapping_bulk_upload', 'presidio-unwanted-parts-' . date('YmdHis') . '.' . $extension);
        $path           = storage_path('app/' . $path);
        $headerMap      = config('bulk-upload.asnUnwantedParts');
        $checkHeader    = $this->checkHeader($path, $headerMap);

        if ($checkHeader) {
            $errors = 'Upload file do not match the template';

            return compact('errors');
        }

        $errors = $this->importUnwantedPartsMappingData($path, 'presidio');

        if ($errors) {
            $message = 'Mapping completed with errors';

            return compact('message', 'errors');
        }

        $message = 'Bulk mapping completed successfully';

        return compact('message');
    }
}
