<?php

namespace App\Services\Asn\Presidio;

use App\Services\Asn\AbstractAsnAssetsService;
use App\Repositories\Asn\PresidioAssetsRepository;

class PresidioAssetsService extends AbstractAsnAssetsService
{
    protected $receivePresidioAssets;
    protected $modelClass;

    public function __construct(PresidioAssetsRepository $receivePresidioAssets)
    {
        $this->receivePresidioAssets = $receivePresidioAssets;
        $this->modelClass = 'App\Models\AsnHardwareMapping';
    }

    /**
     * Return the Repository for the service
     * @return repository
     */
    public function getRepository()
    {
        return 'Facades\App\Repositories\Asn\PresidioAssetsRepository';
    }

    /**
     * Creating array for Export
     *
     * @return array
     */
    public function getExportNestedData($asset, $asnName = '')
    {
        $nestedData["Asset Tag # (Presidio)"]           = disableCSVInjection($asset->asset_tag);
        $nestedData["Serial # (Presidio)"]              = disableCSVInjection($asset->serial_no);
        $nestedData["PO # (Presidio)"]                  = disableCSVInjection($asset->po_id);
        $nestedData["Asset Type (Teqtivity)"]           = disableCSVInjection(optional($asset->assetType)->name);
        $nestedData["Manufacturer Part # (Presidio)"]   = disableCSVInjection($asset->description);
        $nestedData["Hardware Standard (Teqtivity)"]    = disableCSVInjection(optional($asset->makeAndModel)->name);
        $nestedData["Tech Specs (Teqtivity)"]           = disableCSVInjection(optional($asset->technicalSpec)->details);
        $nestedData["City (Presidio)"]                  = disableCSVInjection($asset->asn_dispatch_city);
        $nestedData["Tracking # (Presidio)"]            = disableCSVInjection(optional($asset->assetTracking)->tracking_number);
        $nestedData["Shipment Status"]                  = disableCSVInjection(optional($asset->assetTracking)->shipment_status);

        return $nestedData;
    }

    /**
     * returns column names of report as an array
     */
    public function getReportHeaders()
    {
        $columns = [
            'Asset tag # (Presidio)',
            'Serial # (Presidio)',
            'PO # (Presidio)',
            'Asset Type (Teqtivity)',
            'Manufacturer Part # (Presidio)',
            'Hardware Standard (Teqtivity)',
            'Tech Specs (Teqtivity)',
            'City (Presidio)',
            'Tracking # (Presidio)',
            'Shipment Status'
        ];

        return $columns;
    }
}
