<?php

namespace App\Services\Asn\Insight;

use App\Repositories\Asn\InsightAssetsRepository;
use App\Models\AsnAccessoriesMapping;
use App\Services\Asn\AbstractAsnMappingService;
use Exception;
use Illuminate\Support\Facades\Validator;

class AccessoriesMappingService extends AbstractAsnMappingService
{
    /**
     * @var $InsightAccessoriesMappings
     */
    protected $repository;

    /**
     * AccessoriesMappingService Constructor
     *
     * @param InsightAssetsRepository $repository
     */
    public function __construct(InsightAssetsRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Get Accessories mapping data
     *
     * @return Eloquent
     */
    public function getAccessoriesMappingData()
    {
        return $this->repository->getAccessoriesMappingData()->get();
    }

    /**
     * Filter data
     *
     * @return Eloquent
     */
    public function getAccessoriesMappingSearch()
    {
        $searchText     = request('searchText');
        $insightMappingData = $this->repository->getAccessoriesMappingData();

        if ($searchText) {
            $insightMappingData = $insightMappingData->where('part_no', 'like', '%' . $searchText . '%');
        }

        return $insightMappingData->get();
    }

    /**
     * Bulk upload
     *
     */
    public function bulkUpload()
    {
        $extension = strtolower(request()->file('bulk_upload_insight_accessories_mapping')->getClientOriginalExtension());
        $path = request()->file('bulk_upload_insight_accessories_mapping')->storeAs('public/insight_mapping_bulk_upload', 'insight-accessories-mapping-' . date('m-d-y') . '.' . $extension);
        $path = storage_path('app/' . $path);
        $headerMap = Config('bulk-upload.asnAccessoriesMappingData');
        $checkHeader =  $this->checkHeader($path, $headerMap);
        if ($checkHeader) {
            $errors = 'Upload file do not match the template';

            return compact('errors');
        }

        $errors =  $this->importAccessoryMappingData($path, 'insight');

        if ($errors) {
            $message = 'Mapping completed with errors';

            return compact('message', 'errors');
        }

        $message = 'Bulk mapping successful.';

        return compact('message');
    }
}
