<?php

namespace App\Services\Asn\Connection;

use App\Models\AsnUnwantedPart;
use App\Services\Asn\AbstractAsnMappingService;
use Exception;
use Illuminate\Support\Facades\Validator;

/**
 * Service class for  Connection UnwantedParts
 */
class ConnectionUnwantedPartsService extends AbstractAsnMappingService
{

    /**
     * Gets all unwanted parts added.
     * @return collection
     */
    public function getUnwantedMappingData()
    {
        return AsnUnwantedPart::where('provider', 'connection')->get();
    }

    /**
     * Search through unwanted parts mappings
     * @return collection
     */
    public function getUnwantedMappingSearch()
    {
        $searchText = request('searchText');
        $connectionMappings = AsnUnwantedPart::where('provider', 'connection');

        if ($searchText) {
            $connectionMappings = $connectionMappings->where('part_no', 'like', '%' . $searchText . '%');
        }

        return $connectionMappings->get();
    }

    /**
     * Handles the unwanted parts bulk upload process
     * @return string
     */
    public function bulkUpload()
    {
        setUnlimitedExecutionTimeAndMemoryLimit();
        
        $extension = strtolower(request()->file('unwanted-parts-bulk-upload')->getClientOriginalExtension());
        $path = request()->file('unwanted-parts-bulk-upload')->storeAs('public/connection_mapping_bulk_upload', 'connection-unwanted-parts-' . date('YmdHis') . '.' . $extension);
        $path = storage_path('app/' . $path);
        $headerMap = Config('bulk-upload.asnUnwantedParts');
        $checkHeader =  $this->checkHeader($path, $headerMap);
        if ($checkHeader) {
            $errors = 'Upload file do not match the template';

            return compact('errors');
        }
        $errors =  $this->importUnwantedPartsMappingData($path, 'connection');
        if ($errors) {
            $message = 'Mapping completed with errors';

            return compact('message', 'errors');
        }
        $message = 'Bulk mapping successful.';
        return compact('message');
    }
}
