<?php

namespace App\Services\Asn\Connection;

use App\Models\AsnHardwareMapping;
use App\Repositories\Asn\ConnectionRepository;
use App\Services\Asn\AbstractAsnMappingService;
use Exception;
use Illuminate\Support\Facades\Validator;

/**
 * Service class for Connection HardwareMapping
 */
class ConnectionHardwareMappingService extends AbstractAsnMappingService
{
    public function __construct(ConnectionRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Gets all hardware mappings added.
     * @return collection
     */
    public function getConnectionMappingData()
    {
        return $this->repository->getHardwareMappingData()->get();
    }

    /**
     * Filter data
     *
     * @return Eloquent
     */
    public function filter()
    {
        $hardwareMappingData = $this->repository->getHardwareMappingData();

        $hardwareMappingData = $this->repository->filterHardwareMapping($hardwareMappingData, request('make_and_model'), request('technical_spec'), request('searchText'));

        return $hardwareMappingData->get();
    }

    /**
     * Bulk upload
     */
    public function bulkUpload()
    {
        $extension   = strtolower(request()->file('bulk_upload_connection-hardware-mapping')->getClientOriginalExtension());
        $path        = request()->file('bulk_upload_connection-hardware-mapping')->storeAs('public/connection_mapping_bulk_upload', 'connection-hardware-mapping-' . date('m-d-y') . '.' . $extension);
        $path        = storage_path('app/' . $path);
        $message     = 'Bulk mapping successful.';
        $headerMap = Config('bulk-upload.asnHardwareMappingData');
        $checkHeader =  $this->checkHeader($path, $headerMap);
        if ($checkHeader) {
            $errors = 'Upload file do not match the template';

            return compact('errors');
        }

        $errors =  $this->importHardwareMappingData($path, 'connection');
        if ($errors) {
            $message = 'Mapping completed with errors';
        }

        return compact('message', 'errors');
    }
}
