<?php

namespace App\Services\Asn\Connection;

use App\Models\Asset;
use App\Models\AsnHardwareMapping;
use App\Services\Asn\AbstractAsnAssetsService;

class ConnectionAssetsService  extends AbstractAsnAssetsService
{
        public function __construct()
        {
        }

        /**
         * Return the Repository for the service
         * @return repository
         */
        public function getRepository()
        {
                return 'Facades\App\Repositories\Asn\ConnectionRepository';
        }

        /**
         * Get action buttons
         * @param mixed $asset
         * 
         * @return [type]
         */
        public function getActionButtons($asset)
        {
                $buttonMode = " data-toggle='modal' data-target='#receiveAssetModal' ";
                if ((!$asset->makeAndModel) || (!$asset->assetType) || (!$asset->technicalSpec) || ($asset->serial_no == '') || ($asset->asset_tag == '') || ($asset->po_id == '')) {
                        $buttonMode =  "class='disabled-link'";
                }

                $actions = "<a class='btn btn-link recieve-asn-asset' data-asset='" . $asset->id . "' data-tooltip='tooltip' data-placement='left' title='Receive asset to storage room location' $buttonMode ><i class='icon icon-storage-shelves'></i></a>";
                $actions .= "<a class='btn btn-link' href='' data-toggle='modal' data-asset-id='" . $asset->id . "' data-target='#editModal' data-tooltip='tooltip' data-placement='left' title='Edit asset details'><i class='icon icon-n-edit'></i></a>";

                $asnHardwareMapping =  AsnHardwareMapping::where(['provider' => 'connection', 'part_no' => $asset->part_no])->first();
                if ($asnHardwareMapping == null) {
                        $actions  .= "<a class='btn btn-link' data-asset-id='" . $asset->id . "' data-description='" . disableCSVInjection($asset->part_no) . "' data-toggle='modal' data-target='#addAsnMapping' onclick='addAsnMapping(`" . $asset->part_no . "`)' data-tooltip='tooltip' data-placement='left' title='Add part number mapping'><i class='icon icon-tag-add'></i></a>";
                }
                return $actions  .= "<a class='btn btn-link' data-id='" . $asset->id . "' data-toggle='modal' data-target='#deleteAssetModal' data-tooltip='tooltip' data-placement='left' title='Delete asset'><i class='icon icon-delete-forever'></i></a>";
        }
}
