<?php

namespace App\Services\Asn\Cdw;

use App\Services\Integrations\ShipmentTracking\FedexTracking;
use App\Services\Integrations\ShipmentTracking\UpsTracking;
use App\Models\AssetTracking;
use Carbon\Carbon;

class CdwShipmentService 
{
	public function __construct(FedexTracking $fedexService, UpsTracking $upsService)
    {
    	$this->fedexService = $fedexService;
    	$this->upsService   = $upsService;

    }

	/**
	 * Update the Asset Tracking status by API response
	 */
    public function updateTrackingNumberStatus()
    {
        $trackingNos = AssetTracking::active()->get();
        foreach ($trackingNos as $key => $tackingNo) {
            $trackingDetails = [];

            try {
                if (isUpsTrackingNo($tackingNo->tracking_number)) {
                    $trackingDetails = $this->upsService->getLatestTrackingDetails($tackingNo->tracking_number);
                }

                if (!isUpsTrackingNo($tackingNo->tracking_number)) {
                    $trackingDetails = $this->fedexService->getLatestTrackingDetails($tackingNo->tracking_number);
                }

                $dataToUpdate    = $this->getTrackingDataToUpdate($trackingDetails);
                if ($dataToUpdate) {
                    $tackingNo->update($dataToUpdate);
                }
            } catch (\Throwable $e) {
                //echo $e->getMessage();
                continue;
            }
        }
        return true;
    }

    /**
     * Creating array for save the tracking details
     * 
     * @param $trackingStatus
     */
    public function getTrackingDataToUpdate($trackingDetails)
    {
        if (empty($trackingDetails)) {
            return false;
        }

        //Check status is invalid or error
        if (in_array($trackingDetails['status'] , ['ERROR','No tracking information available','Invalid tracking number','No information found'])) {
            $dateToUpdate['active'] = 0;

            return $dateToUpdate;
        }

        $dateToUpdate['shipment_status']    = $trackingDetails['status'];
        $dateToUpdate['status_updated_on']  = $trackingDetails['updated_on'];
        
        if ($trackingDetails['status'] == 'Delivered') {
            $dateToUpdate['active']         = 0;
        }

        return $dateToUpdate;
    }
} 