<?php

namespace App\Services\Asn\Cdw;

use App\Repositories\Asn\CdwAssetsRepository;
use App\Models\AsnHardwareMapping;
use App\Models\AssetStatus;
use App\Services\Asn\AbstractAsnMappingService;
use Exception;

class CdwHardwareMappingService extends AbstractAsnMappingService
{
    /**
     * @var $repository
     */
    protected $repository;

    /**
     * CdwHardwareMappingService Constructor
     *
     * @param CdwAssetsRepository $repository
     */
    public function __construct(CdwAssetsRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Get cdw mapping data
     *
     * @return Eloquent
     */
    public function getCdwMappingData()
    {
        return $this->repository->getHardwareMappingData()->get();
    }

    /**
     * Filter data
     *
     * @return Eloquent
     */
    public function filter()
    {
        $hardwareMappingData = $this->repository->getHardwareMappingData();
        $hardwareMappingData = $this->repository->filterHardwareMapping($hardwareMappingData, request('make_and_model'), request('technical_spec'), request('searchText'));

        return  $hardwareMappingData->get();
    }

    /**
     * Store mapping to system
     *
     * @return void
     */
    public function store()
    {
        AsnHardwareMapping::Create([
            'provider'          => 'cdw',
            'make_and_model_id' => request('make_and_model'),
            'technical_spec_id' => request('technical_spec'),
            'part_no'           => request('description'),

        ]);

        if (request('sync_now') == 1) {
            $assetStatus = AssetStatus::whereIn('slug', ['cdw_in_transit'])->pluck('id');
            $this->individualHardwarePartResync($assetStatus, request('description'), request('make_and_model'), request('technical_spec'));
        }

        return true;
    }

    /**
     * Bulk upload
     */
    public function bulkUpload()
    {
        $extension   = strtolower(request()->file('bulk_upload_cdw-hardware-mapping')->getClientOriginalExtension());
        $path        = request()->file('bulk_upload_cdw-hardware-mapping')->storeAs('public/cdw_mapping_bulk_upload', 'cdw-hardware-mapping-' . date('m-d-y') . '.' . $extension);
        $path        = storage_path('app/' . $path);
        $message     = 'Bulk mapping successful.';
        $headerMap = Config('bulk-upload.asnHardwareMappingData');
        $checkHeader =  $this->checkHeader($path, $headerMap);
        if ($checkHeader) {
            $errors = 'Upload file do not match the template';

            return compact('errors');
        }

        $errors =  $this->importHardwareMappingData($path, 'cdw');
        if ($errors) {
            $message = 'Mapping completed with errors';
        }

        return compact('message', 'errors');
    }
}
