<?php

namespace App\Services\Asn\Cdw;

use App\Repositories\Asn\CdwAssetsRepository;
use App\Models\AsnAccessoriesMapping;
use App\Services\Asn\AbstractAsnMappingService;
use Exception;

class CdwAccessoriesMappingService extends AbstractAsnMappingService
{
    /**
     * @var $repository
     */
    protected $repository;

    /**
     * CdwAccessoriesMappingService Constructor
     *
     * @param CdwAssetsRepository $repository
     */
    public function __construct(CdwAssetsRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * Get Accessories mapping data
     *
     * @return Eloquent
     */
    public function getAccessoriesMappingData()
    {
        return $this->repository->getAccessoriesMappingData()->get();
    }

    /**
     * Filter data
     *
     * @return Eloquent
     */
    public function getAccessoriesMappingSearch()
    {
        $searchText     = request('searchText');
        $cdwMappingData = $this->repository->getAccessoriesMappingData();

        if ($searchText) {
            $cdwMappingData = $cdwMappingData->where('part_no', 'like', '%' . $searchText . '%');
        }

        return $cdwMappingData->get();
    }

    /**
     * Bulk upload
     *
     */
    public function bulkUpload()
    {
        $extension = strtolower(request()->file('bulk_upload_cdw-accessories-mapping')->getClientOriginalExtension());
        $path = request()->file('bulk_upload_cdw-accessories-mapping')->storeAs('public/cdw_mapping_bulk_upload', 'cdw-accessories-mapping-' . date('m-d-y') . '.' . $extension);
        $path = storage_path('app/' . $path);
        $headerMap = Config('bulk-upload.asnAccessoriesMappingData');

        $checkHeader =  $this->checkHeader($path, $headerMap);
        if ($checkHeader) {
            $errors = 'Upload file do not match the template';

            return compact('errors');
        }

        $errors =  $this->importAccessoryMappingData($path, 'cdw');

        if ($errors) {
            $message = 'Mapping completed with errors';

            return compact('message', 'errors');
        }

        $message = 'Bulk mapping successful.';

        return compact('message');
    }
}
