<?php

namespace App\Services\Api;

use App\Http\Resources\Vendor\VendorCollection;
use App\Repositories\Api\VendorApiRepository;
use Illuminate\Http\Request;

/**
 * Service class for Vendor API
 */
class VendorApiService extends ApiService
{
	/**
     * @var VendorApiRepository
     */
	protected $vendorApiRepository;

	/**
     * Create a new VendorApiService instance.
     *
     * @param VendorApiRepository $vendorApiRepository
     */
	public function __construct(VendorApiRepository $vendorApiRepository)
	{
		$this->vendorApiRepository = $vendorApiRepository;
	}

	/**
	 * Get a paginated list of vendors.
	 *
	 * @param \Illuminate\Http\Request $request
	 *
	 * @return \App\Http\Resources\VendorCollection
	 */
	public function getVendors(Request $request)
	{
		$vendor = $this->vendorApiRepository->getVendors();
		$vendor = $this->vendorApiRepository->searchVendorsWithGeneralQueries($vendor, $request->search);
		$limit  = $this->getQueryLimit($request->limit);

		return new VendorCollection($vendor->paginate($limit));
	}
}
