<?php

namespace App\Services\Api\Slackbot\Traits;

use App\Models\Asset;
use App\Models\SoftwareLicense\SoftwareLicense;

trait SlackbotTrait
{
    /**
     * Retrieve the assets and software licenses associated with a given user.
     *
     * @param User $user The user whose assets are to be retrieved.
     *
     * @return array An array containing the user's assets and software licenses.
     */
    public function getUserAssets($user)
    {
        $data = [];
        $assets = Asset::with('assetStatus', 'assetType', 'makeAndModel', 'technicalSpec')->where('user_id', $user->id)->get();
        $data['assets'] = $assets;

        // Checking that software assets exist and have data in the table
        if (class_exists('App\Models\SoftwareLicense\SoftwareLicense') && SoftwareLicense::count() > 0) {
            $softwareAssets = SoftwareLicense::whereHas('licenseUser', function ($query) use ($user) {
                $query->where('user_id', $user->id);
            })->get();

            $data['software_assets'] = $softwareAssets;
        }

        return $data;
    }
}
