<?php

namespace App\Services\Api\Slackbot;
use App\User;

class SlackbotApiService
{

    /**
     * Get user details by email
     * 
     * @param string $email
     * 
     * @return Collecion
     */
    public function getUserByEmail($email)
    {
        $user = User::select('id', 'first_name', 'last_name', 'email')
                    ->where('email',$email)
                    ->first();

        if (!$user) {
            return $this->getErrorResponse($email. ' not found in Teqtivity');
        }

        return $user;
    }
    
    /**
     * Error reponse array
     *
     * @param String $message
     * @return Array
     */
    public function getErrorResponse($message)
    {
        return [
            'error'         => true, 
            'message'       => $message,
            'status_code'   => 404,
        ];
    }

    /**
     * Success response array
     *
     * @param datatype $data description
     * @param datatype $message description
     * @return Array
     */
    public function getSuccessReponse($data, $message = 'Success')
    {
        return [
            'success'       => true, 
            'message'       => $message,
            'status_code'   => 200,
            'data'          => $data,
        ];
    }

}