<?php

namespace App\Services\Api\Slackbot;

use Illuminate\Http\Request;
use App\Services\Api\Slackbot\Traits\SlackbotTrait;

class OtherUserAssetsService extends SlackbotApiService
{
    use SlackbotTrait;

    /**
     * Take the given email user assets
     *
     * @param Request $request
     *
     * @return Collection
     */
    public function getOtherUserAssets(Request $request)
    {
        /**
         * Check current user existance
         */
        $user = $this->getUserByEmail($request->user_email);

        if (isset($user['error']) && $user['error'] == true) {
            return $user;
        }


        /**
         * Check current user permissions
         */
        if (!$user->can('Slackbot Admin Tools')) {
            return $this->getErrorResponse('You do not have permission to access other users assets');
        }

        /**
         * Check the mentioned user is existing on the server
         */
        $otherUser = $this->getUserByEmail($request->other_user_email);

        if (isset($otherUser['error']) && $otherUser['error'] == true) {
            return $otherUser;
        }

        $data = $this->getUserAssets($otherUser);

        return $this->getSuccessReponse($data, 'Assets');
    }
}
