<?php

namespace App\Services\Api\Slackbot;

use Illuminate\Http\Request;
use App\Services\Api\Slackbot\Traits\SlackbotTrait;

class MyAssetsService extends SlackbotApiService
{
    use SlackbotTrait;

    /**
     * Take the given email user assets
     *
     * @param Request $request
     *
     * @return Collection
     */
    public function getAssets(Request $request)
    {
        $user = $this->getUserByEmail($request->user_email);

        if (isset($user['error']) && $user['error'] == true) {
            return $user;
        }

        $data = $this->getUserAssets($user);

        return $this->getSuccessReponse($data, 'Assets');
    }
}
