<?php

namespace App\Services\Api;

use App\Http\Resources\SiteCode\SiteCodeCollection;
use App\Repositories\Api\SiteCodeApiRepository;
use Illuminate\Http\Request;

/**
 * Service class for Site Code API
 */
class SiteCodeApiService extends ApiService
{
    /**
     * @var SiteCodeApiRepository
     */
    protected $siteCodeApiRepository;

    /**
     * Create a new SiteCodeApiService instance.
     *
     * @param SiteCodeApiRepository $siteCodeApiRepository
     */
    public function __construct(SiteCodeApiRepository $siteCodeApiRepository)
    {
        $this->siteCodeApiRepository = $siteCodeApiRepository;
    }

    /**
     * Get a paginated list of site codes.
     *
     * @param Request $request The HTTP request object.
     *
     * @return SiteCodeCollection
     */
    public function getSiteCodes(Request $request)
    {
        $siteCodes = $this->siteCodeApiRepository->getSiteCodes();
        $siteCodes = $this->siteCodeApiRepository->searchSiteCodesWithGeneralQueries($siteCodes, $request->search);
        $limit  = $this->getQueryLimit($request->limit);

        return new SiteCodeCollection($siteCodes->paginate($limit));
    }
}
