<?php

namespace App\Services\Api;

use App\Http\Resources\MobileCarrier\MobileCarrierCollection;
use App\Repositories\Api\MobileCarrierApiRepository;
use Illuminate\Http\Request;

/**
 * Service class for MobileCarrier API
 */
class MobileCarrierApiService extends ApiService
{
	/**
     * @var MobileCarrierApiRepository
     */
	protected $mobileCarrierApiRepository;

	/**
     * Create a new MobileCarrierApiService instance.
     *
     * @param MobileCarrierApiRepository $mobileCarrierApiRepository
     */
	public function __construct(MobileCarrierApiRepository $mobileCarrierApiRepository)
	{
		$this->mobileCarrierApiRepository = $mobileCarrierApiRepository;
	}

	/**
	 * Get a paginated list of mobileCarriers.
	 *
	 * @param \Illuminate\Http\Request $request
	 *
	 * @return \App\Http\Resources\MobileCarrierCollection
	 */
	public function getMobileCarriers(Request $request)
	{
		$mobileCarrier = $this->mobileCarrierApiRepository->getMobileCarriers();
		$mobileCarrier = $this->mobileCarrierApiRepository->searchMobileCarriersWithGeneralQueries($mobileCarrier, $request->search);
		$limit  = $this->getQueryLimit($request->limit);

		return new MobileCarrierCollection($mobileCarrier->paginate($limit));
	}
}
