<?php

namespace App\Services\Api;

use App\Http\Resources\Manufacturer\ManufacturerCollection;
use App\Repositories\Api\ManufacturerApiRepository;
use Illuminate\Http\Request;

/**
 * Service class for Manufacturer API
 */
class ManufacturerApiService extends ApiService
{
	/**
     * @var ManufacturerApiRepository
     */
	protected $manufacturerApiRepository;

	/**
     * Create a new ManufacturerApiService instance.
     *
     * @param ManufacturerApiRepository $manufacturerApiRepository
     */
	public function __construct(ManufacturerApiRepository $manufacturerApiRepository)
	{
		$this->manufacturerApiRepository = $manufacturerApiRepository;
	}

	/**
     * Get a paginated list of manufacturers.
     *
     * @param Request $request The HTTP request object.
     *
     * @return ManufacturerCollection
     */
	public function getManufacturers(Request $request)
	{
		$manufacturers = $this->manufacturerApiRepository->getManufacturers();
		$manufacturers = $this->manufacturerApiRepository->searchManufacturersWithGeneralQueries($manufacturers, $request->search);
		$limit      = $this->getQueryLimit($request->limit);

		return new ManufacturerCollection($manufacturers->paginate($limit));
	}
}
