<?php

namespace App\Services\Api;

use App\Http\Resources\LocationType\LocationTypeCollection;
use App\Repositories\Api\LocationTypeApiRepository;
use Illuminate\Http\Request;

/**
 * Service class for Location Type API
 */
class LocationTypeApiService extends ApiService
{
    /**
     * @var LocationTypeApiRepository
     */
    protected $locationTypeApiRepository;

    /**
     * Create a new LocationTypeApiService instance.
     *
     * @param LocationTypeApiRepository $locationTypeApiRepository
     */
    public function __construct(LocationTypeApiRepository $locationTypeApiRepository)
    {
        $this->locationTypeApiRepository = $locationTypeApiRepository;
    }

    /**
     * Get a paginated list of location types.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \App\Http\Resources\LocationTypeCollection
     */
    public function getLocationTypes(Request $request)
    {
        $locationType = $this->locationTypeApiRepository->getLocationTypes();
        $locationType = $this->locationTypeApiRepository->searchLocationTypesWithGeneralQueries($locationType, $request->search);
        $limit  = $this->getQueryLimit($request->limit);

        return new LocationTypeCollection($locationType->paginate($limit));
    }
}
