<?php

namespace App\Services\Api\DiscoveryTools;

use App\Http\Resources\DiscoveryTools\WorkspaceOne\DeviceNotCreatedCollection;
use App\Repositories\DiscoveryTools\WorkspaceOneRepository;
use App\Services\Api\ApiService;

/**
 * Service class for Workspace one API service
 */
class WorkspaceOneApiService extends ApiService
{
    protected $mobileIronRepository;

    public function __construct(WorkspaceOneRepository $mobileIronRepository)
    {
        $this->mobileIronRepository = $mobileIronRepository;
    }


    public function getDevicesNotCreated($request)
    {
        $devicesNotCreated = $this->mobileIronRepository->getAssetsNotCreated();
        $limit = $this->getQueryLimit($request->limit);

        return new DeviceNotCreatedCollection($devicesNotCreated->paginate($limit));
    }
}
