<?php

namespace App\Services\Api\DiscoveryTools;

use App\Http\Resources\DiscoveryTools\MobileIron\DeviceNotCreatedCollection;
use App\Repositories\DiscoveryTools\MobileIronRepository;
use App\Services\Api\ApiService;

/**
 * Service class for Mobile iron API service
 */
class MobileIronApiService extends ApiService
{
    protected $mobileIronRepository;

    public function __construct(MobileIronRepository $mobileIronRepository)
    {
        $this->mobileIronRepository = $mobileIronRepository;
    }


    public function getDevicesNotCreated($request)
    {
        $devicesNotCreated = $this->mobileIronRepository->getAssetsNotCreated();
        $limit = $this->getQueryLimit($request->limit);

        return new DeviceNotCreatedCollection($devicesNotCreated->paginate($limit));
    }
}
