<?php

namespace App\Services\Api\DiscoveryTools;

use App\Http\Resources\DiscoveryTools\Kandji\DeviceNotCreatedCollection;
use App\Repositories\DiscoveryTools\KandjiRepository;
use App\Services\Api\ApiService;

/**
 * Service class for Kandji API service
 */
class KandjiApiService extends ApiService
{
    protected $kandjiRepository;

    public function __construct(KandjiRepository $kandjiRepository)
    {
        $this->kandjiRepository = $kandjiRepository;
    }


    public function getDevicesNotCreated($request)
    {
        $devicesNotCreated = $this->kandjiRepository->getAssetsNotCreated();
        $limit = $this->getQueryLimit($request->limit);

        return new DeviceNotCreatedCollection($devicesNotCreated->paginate($limit));
    }
}
