<?php

namespace App\Services\Api\DiscoveryTools;

use App\Http\Resources\DiscoveryTools\Jamf\DeviceNotCreated;
use App\Http\Resources\DiscoveryTools\Jamf\JamfDeviceNotCreatedCollection;
use App\Repositories\DiscoveryTools\JamfRepository;
use App\Services\Api\ApiService;

/**
 * Service class for Locations API service
 */
class JamfApiService extends ApiService
{
    protected $intuneRepository;

    public function __construct(JamfRepository $jamfRepository)
    {
        $this->jamfRepository = $jamfRepository;
    }


    public function getDevicesNotCreated($request)
    {
        $devicesNotCreated = $this->jamfRepository->getAssetsNotCreated();
        $limit = $this->getQueryLimit($request->limit);

        return new JamfDeviceNotCreatedCollection($devicesNotCreated->paginate($limit));
    }
}
