<?php

namespace App\Services\Api\DiscoveryTools;

use App\Http\Resources\DiscoveryTools\Intune\IntuneDeviceNotCreatedCollection;
use App\Repositories\DiscoveryTools\IntuneRepository;
use App\Services\Api\ApiService;

/**
 * Service class for Locations API service
 */
class IntuneApiService extends ApiService
{
    protected $intuneRepository;

    public function __construct(IntuneRepository $intuneRepository)
    {
        $this->intuneRepository = $intuneRepository;
    }


    public function getDevicesNotCreated($request)
    {
        $devicesNotCreated = $this->intuneRepository->getAssetsNotCreated();
        $limit = $this->getQueryLimit($request->limit);

        return new IntuneDeviceNotCreatedCollection($devicesNotCreated->paginate($limit));
    }
}
