<?php

namespace App\Services\Api\DiscoveryTools;

use App\Http\Resources\DiscoveryTools\ChromeBook\DeviceNotCreated;
use App\Http\Resources\DiscoveryTools\ChromeBook\DeviceNotCreatedCollection;
use App\Repositories\DiscoveryTools\ChromebookRepository;
use App\Services\Api\ApiService;

/**
 * Service class for Chrome Book API service
 */
class ChromeBookApiService extends ApiService
{
    protected $chromeBookRepository;

    public function __construct(ChromebookRepository $chromeBookRepository)
    {
        $this->chromeBookRepository = $chromeBookRepository;
    }


    public function getDevicesNotCreated($request)
    {
        $devicesNotCreated = $this->chromeBookRepository->getAssetsNotCreated();
        $limit = $this->getQueryLimit($request->limit);

        return new DeviceNotCreatedCollection($devicesNotCreated->paginate($limit));
    }
}
