<?php

namespace App\Services\Api;

use App\Http\Resources\AssetType\AssetTypeCollection;
use App\Repositories\Api\AssetTypeApiRepository;
use Illuminate\Http\Request;

/**
 * Service class for AssetTypes API
 */
class AssetTypesApiService extends ApiService
{
	/**
     * @var AssetTypeApiRepository
     */
	protected $assetTypeApiRepository;

	/**
     * Create a new AssetTypesApiService instance.
     *
     * @param AssetTypeApiRepository $assetTypeApiRepository
     */
	public function __construct(AssetTypeApiRepository $assetTypeApiRepository)
	{
		$this->assetTypeApiRepository = $assetTypeApiRepository;
	}

	/**
	/**
     * Get AssetTypes.
     *
     * @param Request $request The HTTP request.
     *
     * @return AssetTypeCollection
     */
	public function getAssetTypes(Request $request)
	{
		$limit = $this->getQueryLimit($request->limit);

        $assetTypes = $this->assetTypeApiRepository->getAssetTypes();
		$assetTypes = $this->assetTypeApiRepository->searchAssetTypesWithGeneralQueries($assetTypes, $request->search);

		return new AssetTypeCollection($assetTypes->paginate($limit));
	}
}
