<?php

namespace App\Services\Api;

use App\Http\Resources\AssetStatus\AssetStatusCollection;
use App\Repositories\Api\AssetStatusApiRepository;
use Illuminate\Http\Request;

/**
 * Service class for Asset Status API
 */
class AssetStatusApiService extends ApiService
{
	/**
     * @var AssetStatusApiRepository
     */
	protected $assetStatusApiRepository;

	/**
     * Create a new AssetStatusApiService instance.
     *
     * @param AssetStatusApiRepository $assetStatusApiRepository
     */
	public function __construct(AssetStatusApiRepository $assetStatusApiRepository)
	{
		$this->assetStatusApiRepository = $assetStatusApiRepository;
	}

	/**
     * Get AssetStatuses.
     *
     * @param Request $request
	 *
     * @return AssetStatusCollection
     */
	public function getAssetStatus(Request $request)
	{
		$assetStatus = $this->assetStatusApiRepository->getAssetStatus();
		$assetStatus = $this->assetStatusApiRepository->searchAssetStatusWithGeneralQueries($assetStatus, $request->search);
		$limit      = $this->getQueryLimit($request->limit);

		return new AssetStatusCollection($assetStatus->paginate($limit));
	}
}
