<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use App\User;
use App\Http\Traits\AssetStatusTrait;
use App\Models\Vendor;

class VendorRequiredAssetStatus implements ValidationRule
{
    use AssetStatusTrait;

    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct(protected $assetStatusId, protected int $count, protected $status = null) {}

    /**
     * Run the validation rule.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $vendorRequiredStatuses = $this->getVendorRequiredAssetStatuses();

        if (in_array($this->assetStatusId, $vendorRequiredStatuses)) {

            if (!Vendor::find($value)) {
                $fail('Line no ' . $this->count . ' : Vendor is required.');
                return;
            }
        }
    }
}
