<?php

namespace App\Rules;

use DateTime;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class ValidatePastDate implements ValidationRule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    protected $assetStatusId;
    public function __construct(protected $dateField, protected $format = 'm/d/Y', protected $count = 1, protected $msgfield = null)
    {
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function validate($attribute, $value,  Closure $fail): void
    {
        if ($this->dateField) {
            $date = DateTime::createFromFormat('!' . $this->format, $this->dateField);
            // Check if the date is in the future
            if ($date > new DateTime()) {
                $fail('Line no ' . $this->count . ' : The ' . $this->msgfield . ' date cannot be a future date');
                return;
            }
        }
    }
}
