<?php

namespace App\Rules;

use App\Models\Asset;
use App\Models\MakeAndModel;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class ValidateMakeModelAssetTypeMatch implements ValidationRule
{

    /**
     * Create a new rule instance.
     *
     * @param int|null $assetTypeId
     * @param int|null $assetId
     * @param int|null $count
     */
    public function __construct(protected $assetTypeId = null, protected $assetId = null, protected $count = null) {}

    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        if (!$value) {
            return; // Allow null values as it's nullable
        }

        $assetTypeId = $this->assetTypeId;

        // If asset_type_id is not provided, fallback to asset's asset_type_id
        if (!$assetTypeId) {
            $asset = Asset::select('asset_type_id')->find($this->assetId);

            if ($asset === null) {
                return;
            }

            $assetTypeId = $asset->asset_type_id;
        }

        // Check if the make_and_model belongs to the asset type
        if (MakeAndModel::select('id')->where('id', $value)->where('asset_type_id', $assetTypeId)->exists() === false) {
            $lineInfo = $this->count ? 'Line no ' . $this->count . ' : ' : '';
            $fail($lineInfo . 'The selected make and model does not belong to the asset type.');
            return;
        }
    }
}
