<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class ValidateFileExtension implements ValidationRule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct(protected $originalExtension, protected $allowedExtensions)
    {
    }

    /**
     * Run the validation rule.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        if (!empty($this->allowedExtensions) && !in_array($this->originalExtension, $this->allowedExtensions)) {
            $word = (count($this->allowedExtensions) > 1) ? ' are' : ' is';
            $fail('Incorrect file format. Please Upload ' . implode(",", $this->allowedExtensions) . $word . ' file.');
            return;
        }
    }
}
