<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use App\User;
use App\Http\Traits\AssetStatusTrait;

class UserRequiredAssetStatus implements ValidationRule
{
    use AssetStatusTrait;

    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct(protected $assetStatusId, protected int $count, protected $status = null)
    {
    }

    /**
     * Run the validation rule.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        $userAssetStatuses = $this->getUserRequiredAssetStatuses();
        if (in_array($this->assetStatusId, $userAssetStatuses)) {

            if ($this->status && !User::where('status', 1)->find($value)) {
                $fail('Line no ' . $this->count . ' : The User must be a Valid User');
                return;
            }

            if (!User::find($value)) {
                $fail('Line no ' . $this->count . ' : The User must be a Valid User');
                return;
            }
        }
    }
}
