<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use App\User;

/**
 * Class UniqueEmployeeIdForEmail
 *
 * This rule checks if the provided employee_id is unique for a given email address.
 *
 * @package App\Rules
 */
class UniqueEmployeeIdForEmail implements ValidationRule
{

    /**
     * Create a new rule instance.
     *
     * @param string $email The email address for which to check uniqueness.
     */
    public function __construct(protected $email)
    {
    }

    /**
     * Run the validation rule.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        // Check if the employee_id is unique for the given email
        if (User::where('email', "!=", $this->email)->where('employee_id', $value)->count() !== 0) {
            $fail('The employee ID is already associated with another user.');
            return;
        }
    }
}
