<?php

namespace App\Rules\SoftwareLicense;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class LicenseKeyLength implements ValidationRule
{

    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct(protected $lengthArray = [6, 20], protected $count = null)
    {
    }

    /**
     * Run the validation rule.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        if (!$value) {
            return;
        }

        $word = explode(",", $value);
        $keyLengths = [];
        foreach ($word as $key => $value) {
            if (strlen($value) < $this->lengthArray[0] || strlen($value) > $this->lengthArray[1]) {
                array_push($keyLengths, strlen($value));
            }
        }
        if (!empty($keyLengths)) {
            if ($this->count) {
                $fail('Line no ' . $this->count . ' : Please enter keys of  ' . $this->lengthArray[0] . ' to ' . $this->lengthArray[1] . ' characters in length');
                return;
            }
            $fail('Please enter keys of  ' . $this->lengthArray[0] . ' to ' . $this->lengthArray[1] . ' characters in length');
            return;
        }
    }
}
