<?php

namespace App\Rules\SoftwareLicense;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class LicenseKeyFormat implements ValidationRule
{

    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct(protected $format = '/^[a-zA-Z0-9_,-]+$/i', protected $count = null)
    {
    }

    /**
     * Run the validation rule.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        // dd($value);
        if (!$value) {
            return;
        }
        $word = explode("\n", $value);
        foreach ($word as $key => $value) {
            if (!preg_match($this->format, $value)) {
                if ($this->count) {
                    $fail('Line no ' . $this->count . ' : Only letters, numbers, underscores and -  is allowed in license key');
                    return;
                }
                $fail('Only letters, numbers, underscores and -  is allowed in license key');
                return;
            }
        }
        return;
    }
}
