<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use App\Models\Location;
use App\Http\Traits\AssetStatusTrait;

class LocationRequiredAssetStatus implements ValidationRule
{
    use AssetStatusTrait;

    protected $assetStatusId;
    protected $count;
    protected $installLocationAssetStatuses;
    protected $storageLocationAssetStatuses;

    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct($assetStatusId, int $count)
    {
        $this->assetStatusId = $assetStatusId;
        $this->count = $count;
        $this->installLocationAssetStatuses = $this->getInstallLocationRequiredAssetStatuses();
        $this->storageLocationAssetStatuses = $this->getStorageLocationRequiredAssetStatuses();
    }

    /**
     * Run the validation rule.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        if (in_array($this->assetStatusId, $this->installLocationAssetStatuses)) {
            $location = Location::find($value);

            if (!$location || optional($location->locationType)->location_type_name !== "Install") {
                $fail('Line no ' . $this->count . ' : The Location must be a Valid, Install Location');
                return;
            }
        }

        if (in_array($this->assetStatusId, $this->storageLocationAssetStatuses)) {
            $location = Location::find($value);

            if (!$location || optional($location->locationType)->location_type_name !== "Storage") {
                $fail('Line no ' . $this->count . ' : The Location must be a Valid, Storage Location');
                return;
            }
        }
    }
}
