<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use App\Models\Location;

class LocationExistsAndIsStorage implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        // Check if the location with the given name exists and is a storage location
        $location = Location::warehouses()->where('room_name', $value)->first();

        if (!$location) {
            $fail('The selected location name does not exist or is not a storage location.');
            return;
        }
    }
}
