<?php

namespace App\Rules;

use Closure;
use Illuminate\Contracts\Validation\ValidationRule;
use App\Models\Location;

class CheckLocationFreezeRule implements ValidationRule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct(protected $count) {}

    /**
     * Run the validation rule.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        if (!$value) {
            $fail('Line no ' . $this->count . ' : Location is required.');
            return;
        }
        if (Location::find($value)?->is_freeze == 1) {
            $fail('Line no ' . $this->count . ' : Selected location is frozen for cycle count ');
            return;
        }
    }
}
