<?php

namespace App\Rules;

use DateTime;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class BulkUploadDateFormat implements ValidationRule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    protected $assetStatusId;
    public function __construct(protected $dateField, protected $format = 'm/d/Y', protected $count = 1, protected $msgfield = null)
    {
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function validate($attribute, $value,  Closure $fail): void
    {
        if ($this->dateField) {
            $date = DateTime::createFromFormat('!' . $this->format, $this->dateField);
            if (!$date) {
                $fail('Line no ' . $this->count . ' : The ' . $this->msgfield . ' date is not in the ' . $this->format . ' format');
                return;
            }
            if ($date->format($this->format) != $value) {
                $fail('Line no ' . $this->count . ' : The ' . $this->msgfield . ' date is not in the ' . $this->format . ' format');
                return;
            }
            if ($this->format == 'm/d/Y') {
                list($mm, $dd, $yyyy) = explode('/', $this->dateField);
                if (!checkdate($mm, $dd, $yyyy)) {
                    $fail('Line no ' . $this->count . ' : The ' . $this->msgfield . ' date is not in the ' . $this->format . ' format');
                    return;
                }
            }
        }
    }
}
