<?php

namespace App\Rules;

use App\Models\AssetType;
use Exception;
use Facades\App\Models\MakeAndModel;
use Closure;
use Illuminate\Contracts\Validation\ValidationRule;

class AssetTypeValidation implements ValidationRule
{
    /**
     * Create a new rule instance.
     *
     * @return void
     */
    public function __construct(private $data)
    {
        $this->data = $data;
    }

    /**
     * Determine if the validation rule passes.
     *
     * @param  string  $attribute
     * @param  mixed  $value
     * @return bool
     */
    public function validate($attribute, $value, Closure $fail): void
    {
        $data   = $this->data;
        try {
            $assetTypeId = AssetType::find($value)->id;
            $makeModel = MakeAndModel::find($data['make_and_model_id']);
            if ($makeModel->asset_type_id != $assetTypeId) {
                $fail('The asset type and hardware standard combination does not exist.');
                return;
            }
        } catch (Exception) {
            $fail('The asset type and hardware standard combination does not exist.');
            return;
        }
    }
}
