<?php

namespace App\Repositories;

use App\User;
use App\Models\Asset;
use App\Models\AssetHistory;
use App\Models\AssetStatus;
use Carbon\Carbon;

class TermAssets
{
    //terminated user having atleast one assets.
    public function getTermAssets()
    {
        return User::with('assets', 'position', 'employeeType', 'department', 'userJiraMappings', 'assets.assetTracking', 'termAssetsComment', 'termAssetsComment.addedBy')
            ->where('status', '!=', 1)->withCount('assets')->withCount('termAsset')->has('termAsset', '>', 0);
    }

    //fiter user with user fields
    public function searchUserWithUserFields($users, $field, $value)
    {
        $users = $users->when(
            $value ?? false,
            function ($users, $value) use ($field) {
                return is_array($value) ? $users->whereIn($field, $value) : $users->where($field, $value);
            }
        );
        //$field=='city'?dd($users->toSql()):'';
        return $users;
    }

    //filter data with user has assets 'equal to' or more than selected count
    public function searchUserWithNumberOfAssets($users, $noOfAssets)
    {
        if ($noOfAssets != '') {
            $users = $users->has('termAsset', '=', $noOfAssets);
        }

        return $users;
    }

    //filter data with user have legal hold
    public function searchUserWithLegalHold($users, $legalHold)
    {
        if ($legalHold == '0') {
            $users = $users->where('legalhold', 0);
        } elseif ($legalHold == '1') {
            $users = $users->where('legalhold', 1);
        }

        return $users;
    }

    //filter data with  ticket number
    public function searchUserWithTicketNo($users, $ticketNo)
    {
        $users = $users->when(
            $ticketNo ?? false,
            function ($users, $ticketNo) {
                return $users->whereHas(
                    'userJiraMappings',
                    function ($users) use ($ticketNo) {
                        return $users->where('ticket_no', 'like', '%' . $ticketNo . '%');
                    }
                );
            }
        );

        return $users;
    }

    //filter data with user having ticket
    public function searchUserWithHasTicket($users, $hasTicket)
    {
        /*if ($hasTicket == '0') {
            $users = $users->whereHas('userJiraMappings', function ($users) {
                return $users->whereNull('ticket_no');
            });
        } elseif ($hasTicket == '1') {
            $users = $users->whereHas('userJiraMappings', function ($users) {
                return $users->whereNotNull('ticket_no');
            });
        }*/
        if ($hasTicket == '1') {
            $users = $users->whereHas('userJiraMappings', function ($users) {
                return $users->whereNotNull('ticket_no');
            });
        }

        return $users;
    }

    //filter data with user terminated date count
    public function searchUserWithOutstandingDays($users, $outstandingDays)
    {
        $outstandingDays = (int) $outstandingDays;
        if ($outstandingDays && $outstandingDays != '') {
            $from = ($outstandingDays - 1) * 30; //0
            $to = ($outstandingDays) * 30; //30
            if ($outstandingDays == 1) {
                $users = $users->where('terminated_date', '<=', Carbon::now()->subDays($from));

                $users = $users->where('terminated_date', '>=', Carbon::now()->subDays($to));
            } elseif ($outstandingDays != 5) {
                $users = $users->where('terminated_date', '<', Carbon::now()->subDays($from));

                $users = $users->where('terminated_date', '>=', Carbon::now()->subDays($to));
            } else {
                $users = $users->where('terminated_date', '<=', Carbon::now()->subDays($to));
            }
        }

        return $users;
    }

    //filter data with user terminated date start from
    public function searchUserWithFromDate($users, $dateFrom)
    {
        if ($dateFrom && isDateString($dateFrom)) {
            $dateFrom = convert_to_db_date($dateFrom);
            if ($dateFrom != null) {
                $users = $users->where('terminated_date', '>=', $dateFrom);
            }
        }

        return $users;
    }

    //filter data with user terminated date end
    public function searchUserWithToDate($users, $dateTo)
    {
        if ($dateTo && isDateString($dateTo)) {
            $dateTo = convert_to_db_date($dateTo);
            if ($dateTo != null) {
                $users = $users->where('terminated_date', '<=', $dateTo);
            }
        }

        return $users;
    }
    /**
     * Get all uncollected assets of a user
     * @param $userId
     * @return $uncollectedAssetsArray
     */

    public function getAllUncollectedUserAssets($userId)
    {
        return Asset::with('assetStatus', 'makeAndModel', 'user', 'latestAssetHistory')
            ->where('user_id', $userId)
            ->whereIn('asset_status_id', AssetStatus::whereIn('slug', ['assigned', 'loaned', 'pending_return'])->pluck('id'))
            ->whereHas('assetType', function ($query) {
                $query->whereNotIn('slug', ['mobile_phone_number']);
            })
            ->get();
    }
    /**
     * Get user assignment ticket no from history
     * @param $userId,$assetId
     * @return $ticketNo
     */

    public function getUserAssignmentTicket($userId, $assetId)
    {
        $assignedStatusId = AssetStatus::where('slug', 'assigned')->first()->id;
        if ($assignedStatusId) {
            return optional(
                AssetHistory::where('new_user_id', $userId)
                    ->where('action', 'status_updated')
                    ->where('asset_id', $assetId)
                    ->where('new_asset_status_id', $assignedStatusId)
                    ->orderBy('created_at', 'desc')
                    ->first()
            )->ticket_no;
        }
        return;
    }

    /**
     * Retrieves the collection statistics.
     *
     * @return Builder
     */
    public function getCollectionStatistics()
    {
        return  User::select('id')->where('status', '!=', 1)->withCount('termAsset')->withCount('receivedAsset');
    }
}
