<?php

namespace App\Repositories\Settings\History;

use App\Models\RoleChangeHistory;
use App\User;
use Illuminate\Support\Facades\Auth;

class UserRoleChangeHistoryRepository
{
    /**
     * Constructs a new instance of the class.
     *
     * @param RoleChangeHistory $model The eloquent model for role change history.
     */
    public function __construct(protected RoleChangeHistory $model) {}

    /**
     * Fetching role change history
     *
     * @return eloquent::query()
     */
    public function getRoleChangeHistory()
    {
        return $this->model::with(
            'user:id,email',
            'changedBy:id,first_name,last_name',
            'fromRole:id,name',
            'toRole:id,name'
        );
    }

    /**
     * Adds a role change history for a user.
     *
     * @param object $user The user object.
     * @return bool
     */
    public function addRoleChangeHistory($user)
    {
        $newRoleId = $user->user_type_id;
        $oldUser = User::select('id', 'user_type_id')->findOrFail($user->id);
        $loggedInUserId = Auth::id() ?? 0;

        $this->model->create([
            'user_id' => $oldUser->id,
            'changed_by_user_id' => $loggedInUserId,
            'from_user_type_id' => $oldUser->user_type_id,
            'to_user_type_id' => $newRoleId,
            'changed_by' => ($loggedInUserId == 0) ? "Teqtivity Automation" : NULL,
        ]);

        return true;
    }
}
