<?php

namespace App\Repositories\Settings\History;

use App\Models\UserLoginHistory;

class UserLoginHistoryRepository
{
    /**
     * Constructor for the class.
     *
     * @param UserLoginHistory $model The UserLoginHistory object.
     */
    public function __construct(protected UserLoginHistory $model) {}

    /**
     * Retrieves all user login history records with associated user, user's position, and user's user type, excluding Teqtivity users.
     *
     * @return \Illuminate\Database\Eloquent\Builder|\Illuminate\Database\Eloquent\Collection
     */
    public function getHistory()
    {
        return $this->model::with(
            'user:id,first_name,last_name,email,city,business_title,status,user_type_id',
            'user.userType:id,name'
        )->nonTeqtivityUsers();
    }
}
