<?php

namespace App\Repositories\Settings\History;

use App\Models\ApiBlockedIp;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;

class ApiBlockedIpRepository
{
    /**
     * Retrieves the blocked IP addresses from the API.
     *
     * @return \Illuminate\Database\Eloquent\Builder The blocked IP addresses from the API.
     */
    public function getApiBlockedIp()
    {
        return ApiBlockedIp::whereNotNull('blocked_at');
    }

    /**
     * Releases the blocked IP address.
     *
     * @param int $id The ID of the blocked IP address to release.
     * @return bool True if the IP address was successfully released, false otherwise.
     */
    public function releaseApiBlockedIp($id)
    {
        try {
            $apiBlockedIp = ApiBlockedIp::findOrFail($id);

            // Reset the columns
            $apiBlockedIp->update([
                'blocked_at'   => null,
                'released_at'  => Carbon::now(),
                'attempts'     => 0,
                'released_by'  => Auth::id(),
            ]);

            return true;
        } catch (\Exception $e) {

            return false;
        }
    }
}
