<?php

namespace App\Repositories\Scim;

use App\Models\Country;
use App\Models\EmployeePosition;
use App\Models\Department;
use App\Models\EmployeeType;
use App\Models\Division;
use App\Models\State;
use App\User;
use Cache;

class UserRepository
{
    protected $charactersToBeReplaced = ['?' => '•'];

    public function getPositionId($fieldValue)
    {
        if (!$fieldValue) {
            return null;
        }

        $slug = str_slug($fieldValue, '_');

        $position = EmployeePosition::firstOrNew(['slug' => trim($slug)], ['name' => $fieldValue]);

        if (!$position->exists) {
            $position->save();
        }

        return $position->id;
    }

    public function getDepartmentId($fieldValue)
    {
        if (!$fieldValue) {
            return null;
        }

        $slug = str_slug($fieldValue, '_');
        $department = Department::firstOrCreate(['slug' => trim($slug)], ['name' => $fieldValue]);

        return $department->id;
    }

    public function getEmployeeTypeId($fieldValue)
    {
        if (!$fieldValue) {
            return null;
        }

        $slug = str_slug($fieldValue, '_');

        $employeeType = EmployeeType::firstOrNew(['slug' => trim($slug)], ['name' => $fieldValue]);

        if (!$employeeType->exists) {
            $employeeType->save();
        }

        return $employeeType->id;
    }

    public function getManagerId($fieldValue)
    {
        if ($fieldValue) {
            $user = User::where('email', $fieldValue)->select('id')->first();
            if ($user) {
                return $user->id;
            }
        }

        return null;
    }

    public function getDivisionId($fieldValue)
    {
        if ($fieldValue) {
            return Division::firstOrCreate(['name' => $fieldValue])->id;
        }

        return null;
    }

    public function getStateId($fieldValue)
    {
        $stateId = null;

        if ($fieldValue) {
            $stateId = State::firstOrCreate(['code' => $fieldValue])->id;
        }

        return $stateId;
    }

    public function getCountryId($fieldValue)
    {
        $countryId = null;

        if ($fieldValue) {
            $countryId = Country::where('country_code', $fieldValue)->pluck('id')->first();
        }

        return $countryId ? $countryId : null;
    }
}
