<?php

namespace App\Repositories\Revivn;

use App\Models\Asset;
use App\Models\RevivnAsset;

class RevivnAssetsRepository
{

    /**
     * Get the data.
     *
     * @return mixed
     */
    public function getData()
    {
        $assets = Asset::with('assetType', 'makeAndModel', 'makeAndModel.manufacturer', 'technicalSpec', 'revivnAsset', 'revivnAsset.revivnPickup')
            ->whereHas('revivnAsset');

        return $assets;
    }

    /**
     * Retrieves auto-created devices with specific relationships and conditions.
     * When the assets autocreated from revivn the asset type, make nad model and technical specs will be EOL Asset CODD 
     * when the user updates it it will be removed from the report
     * @return mixed
     */
    public function getAutoCreatedDevices()
    {
        $autoCreatedDevices = Asset::with('assetType', 'makeAndModel', 'makeAndModel.manufacturer', 'technicalSpec', 'revivnAsset', 'revivnAsset.revivnPickup')
            ->whereHas('revivnAsset')
            ->whereHas('assetStatus', fn ($query) => $query->whereIn('slug', ['end_of_life', 'end_of_life_data_wiped']))
            ->whereHas('assetType', fn ($query) => $query->where('slug', 'eol_asset_codd'));
        return $autoCreatedDevices;
    }

    /**
     * A description of the entire PHP function.
     *
     * @param datatype $search description
     * @param datatype $type description
     * @return Some_Return_Value
     */
    public function filterField($search, $type)
    {
        return RevivnAsset::distinct()->select("$type")->where("$type", 'like', '%' . $search . '%');
    }
}
