<?php

namespace App\Repositories;

use App\Models\RetrieverDevice;
use App\Models\Asset;

/**
 * Repository class for Retriever Report
 */
class RetrieverRepository
{
    /**
     * getRetrieverReportData - get device details for RetrieverReport
     *
     * @return object
     */
    public function getRetrieverReportData()
    {
        return RetrieverDevice::with('user');
    }

    /**
     * Get assets of an user
     * 
     * @param int $userId
     * 
     * @return Query
     */
    public function getUserTeqAssets($userId)
    {
        return Asset::with('assetStatus', 'makeAndModel', 'technicalSpec')
            ->where('user_id', $userId);
    }

    /**
     * Filter with Request Charger Field
     *
     * @param  mixed $query
     * @param  boolean $value
     * @return void
     */
    public function filterWithRequestCharger($query, $value)
    {
        if ($value == 1) {
            $query = $query->where('request_charger', '=', 1);
        }

        if ($value == 2) {
            $query = $query->where('request_charger', '=', 0)->orWhereNull('request_charger');
        }

        return $query;
    }

    /**
     * To populate data in some of reports filters
     * @param mixed $search
     * @param mixed $type
     * 
     * @return [type]
     */
    public function filterField($search, $type)
    {
        $res = RetrieverDevice::distinct()->select("$type")->where("$type", 'like', '%' . $search . '%')->limit(15)->get();
        $result = $res->mapWithKeys(function ($item, $key) use ($type) {
            return [
                $key => [
                    'id' => $item[$type],
                    'text' => $item[$type],
                ]
            ];
        });

        return $result;
    }

    /**
     * getdeactivated order reason from Retriver table
     *
     * @return object
     */
    public function getDeactivatedReason($retriverId)
    {
        return optional(RetrieverDevice::find($retriverId))->deactivated_reason;
    }
}
