<?php

namespace App\Repositories\Reports;

use App\Models\Asset;
use Carbon\Carbon;

/**
 * WarrantyExpirationDate - Repository for warranty reports
 */
class WarrantyExpirationDateRepository
{
    
    protected $assetModel;

    public function __construct(Asset $assetModel)
    {
        $this->assetModel = $assetModel;
    }
    
    
    
    /**
     * getAssetsByWarrantyData - get assets for warranty reports page
     *
     * @return object
     */
    public function getAssetsByWarrantyData()
    {
        return $this->assetModel->with(
                'location:id,room_name', 'user:id,first_name,last_name,city',
                'makeAndModel:id,name,manufacturer_id',
                'makeAndModel.manufacturer:id,name',
                'technicalSpec:id,details','assetStatus:id,name'
            )
            ->isComputer()
            ->doesNotHaveAssetStatus([
                'end_of_life',
                'end_of_life_data_wiped',
                'rma_returned'
            ]);
    }

    /**
     * searchAssetByExpireDays
     *
     * @param  mixed $query
     * @param  mixed $daysToExpire
     * @return void
     */
    public function filterWithExpiryDate($query, $daysToExpire)
    {
        if (!$daysToExpire)
            return $query;

        $daysArray = explode("~", $daysToExpire);

        if ($daysArray[0] != '' && $daysArray[0] != 0) {
            $dateFrom = Carbon::now()->addDays($daysArray[0])->toDateString();
            $query = $query->where('warranty_end_date', '>=', $dateFrom);
        }

        if ($daysArray[1] != '') {
            $dateTo   = Carbon::now()->addDays($daysArray[1])->toDateString();
            $query = $query->where('warranty_end_date', '<=', $dateTo);
        }

        return $query;
    }
}
